-----------------------------------------------------------
--Search and Replace All as follows:
-- 1) Replace <DB> with the name of the database to create.
--    (e.g., Substitute Dining for <DB> be sure to delete the angle brackets)
-- 2) Replace <PATH> with the full path to this file and 
--    others associated with it. Ensure it ends with a 
--    backslash. e.g., replace <PATH> with C:\MyDatabases\
-----------------------------------------------------------
--
IF NOT EXISTS(SELECT * FROM sys.databases
          WHERE name = N'<DB>')
	CREATE DATABASE <DB>
GO
USE <DB>
--
-- Alter the path so the script can find the CSV files
--
DECLARE
   @data_path nvarchar(256);
SELECT @data_path = '<PATH>';
--
--GO
-- =======================================
-- Delete existing tables
--
If Exists(SELECT * FROM sys.tables WHERE name = N'Diners') drop table Diners;
--
-- Create tables
--
CREATE TABLE Diners(
	DinerID int NOT NULL,
	DineDate date NULL,
	DOW nvarchar(50) NULL,
	MealTime nvarchar(50) NULL,
	Gender nvarchar(50) NULL,
	Number int NULL,
	BillTotal money NULL,
	Dessert bit NULL,
 CONSTRAINT PK_Diners PRIMARY KEY (DinerID)
);

--
-- Load table data
-- 1: Diners
--
EXECUTE (N'BULK INSERT Diners FROM ''' + @data_path + N'Diners.csv''
WITH (
    CHECK_CONSTRAINTS,
    CODEPAGE=''ACP'',
    DATAFILETYPE = ''char'',
    FIELDTERMINATOR= '','',
    ROWTERMINATOR = ''\n'',
    KEEPIDENTITY,
    TABLOCK
);');


GO
-- ====================================
-- List the table names and row counts
SET NOCOUNT ON
SELECT 'Diners' "Table", COUNT(*) "Rows" FROM Diners
ORDER BY 1;
SET NOCOUNT OFF
Go
